define([
    'underscore',
    'marionette',
    'modules/notifications/notification-list-item-view',
    'text!modules/notifications/notifications-list.html',
],
function(_, Marionette, ItemView, template) {
    'use strict';
    
    return Marionette.CompositeView.extend({
        template: _.template(template),
        childViewContainer: '.notifications-list',
        childView: ItemView,
        onRenderCollection: function() {
            this.styleLastChild();
        },
        styleLastChild: function() {
            this.$childViewContainer.children('li.ui-last-child').removeClass('ui-last-child');
            this.$childViewContainer.children('li:last-of-type').addClass('ui-last-child');
        },
    });
});
